<?php

namespace Elgg\GoogleMeet;

use Elgg\PluginHooksService;

class Plugin {

    public static function init() {
        // Register hooks
        elgg_extend_view('elgg.css', 'google_meet/css/google_meet');
        elgg_register_plugin_hook_handler('entity:view', 'object', [static::class, 'addGoogleMeetButton']);
        elgg_register_plugin_hook_handler('action', 'event/create', [static::class, 'saveGoogleMeetLink']); // For events
        elgg_register_plugin_hook_handler('action', 'event/edit', [static::class, 'saveGoogleMeetLink']); // For events edits
        elgg_register_plugin_hook_handler('entity:view', 'object', [static::class, 'displayGoogleMeetLink']); // Display link

    }

    public static function addGoogleMeetButton($hook, $type, $return, $params) {
      if (!$return) {
        $entity = $params['entity'];

        if ($entity instanceof \ElggObject && $entity->getSubtype() == 'event') { // Only for events
            $button = elgg_view_form('google_meet/add', [
                'action' => elgg_normalize_url('action/google_meet/add'),
                'entity_guid' => $entity->guid,
            ]);
            $return .= $button;
        }

      }
      return $return;
    }


    public static function saveGoogleMeetLink($hook, $type, $return, $params) {
        $event = get_entity(get_input('guid')); // Get the event
        if (!$event instanceof \ElggObject || $event->getSubtype() != 'event') {
          return $return; // Only process for events
        }

        $google_meet_link = get_input('google_meet_link');
        if ($google_meet_link) {
            $event->google_meet_link = $google_meet_link;
            $event->save();
        }
        return $return;
    }

    public static function displayGoogleMeetLink($hook, $type, $return, $params) {
        if (!$return) {
            $entity = $params['entity'];
            if ($entity instanceof \ElggObject && $entity->getSubtype() == 'event' && $entity->google_meet_link) {
                $return .= "<div class='google-meet-link'>";
                $return .= elgg_format_element('label', ['for' => 'google_meet_link'], elgg_echo('google_meet:link'));
                $return .= "<a href='" . $entity->google_meet_link . "' target='_blank' rel='noopener noreferrer'>" . $entity->google_meet_link . "</a>";
                $return .= "</div>";

            }
        }
        return $return;
    }
}